/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.ChangeEvent;
import com.olyno.skent.skript.events.bukkit.MoveEvent;
import com.olyno.skent.util.AsyncEffect;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.bukkit.event.Event;

@Name(value="Move File or directory")
@Description(value={"Moves a file or a directory."})
@Examples(value={"command move:\n\ttrigger:\n\t\tmove file path \"plugins/Skript/config.sk\" to file path \"plugins/config.sk\"\n\t\tbroadcast \"Got a new config!\"", "# If you need to wait the end of the effect before execute a part of your code, you can\n# use this effect as a section effect.# The code after this effect section will be executed when the effect section has finished to be executed.\n\ncommand move:\n\ttrigger:\n\t\tmove file path \"plugins/Skript/config.sk\" to file path \"plugins/config.sk\":\n\t\t\tbroadcast \"Got a new config!\""})
@Since(value="1.0")
public class EffMoveFileDir
extends AsyncEffect {
    private Expression<Path> paths;
    private Expression<Path> target;
    private Boolean withReplace = false;
    private boolean isSingle;

    @Override
    protected boolean initAsync(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.paths = expr[0];
        this.target = expr[1];
        this.withReplace = matchedPattern == 1;
        this.isSingle = this.paths.getSource().isSingle();
        return true;
    }

    @Override
    protected void executeAsync(Event e) {
        Path[] pathArray;
        if (this.isSingle) {
            Path[] pathArray2 = new Path[1];
            pathArray = pathArray2;
            pathArray2[0] = (Path)this.paths.getSingle(e);
        } else {
            pathArray = (Path[])this.paths.getArray(e);
        }
        Path[] pathsList = pathArray;
        Path targetFile = (Path)this.target.getSingle(e);
        for (Path path : pathsList) {
            if (Files.isDirectory(targetFile, new LinkOption[0])) {
                targetFile = Paths.get(targetFile.toString() + File.pathSeparator + path.getFileName(), new String[0]).normalize();
            }
            Path destFile = targetFile;
            try {
                if (this.withReplace.booleanValue()) {
                    Files.move(path, destFile, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.move(path, destFile, new CopyOption[0]);
                }
                new MoveEvent(path, destFile);
                new ChangeEvent(destFile.getParent());
                new ChangeEvent(path);
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "move " + this.paths.toString(e, debug) + " to " + this.target.toString(e, debug);
    }

    static {
        EffMoveFileDir.registerAsyncEffect(EffMoveFileDir.class, "move %paths% to %path%", "move %paths% to %path% with replace");
    }
}

