/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.ChangeEvent;
import com.olyno.skent.skript.events.bukkit.DeleteEvent;
import com.olyno.skent.util.AsyncEffect;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import org.bukkit.event.Event;

@Name(value="Delete File or directory")
@Description(value={"Deletes a file or a directory."})
@Examples(value={"command delete:\n\ttrigger:\n\t\tdelete file path \"plugins/Skript/scripts/myAwesomeScript.sk\"\n\t\tbroadcast \"Oh no, my awesome script!\"", "# If you need to wait the end of the effect before execute a part of your code, you can\n# use this effect as a section effect.\n# The code after this effect section will be executed when the effect section has finished to be executed.\n\ncommand delete:\n\ttrigger:\n\t\tdelete file path \"plugins/Skript/scripts/myAwesomeScript.sk\":\n\t\t\tbroadcast \"Oh no, my awesome script!\""})
@Since(value="1.0")
public class EffDeleteFileDir
extends AsyncEffect {
    private Expression<Path> paths;
    private boolean isSingle;

    @Override
    protected boolean initAsync(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.paths = expr[0];
        this.isSingle = this.paths.getSource().isSingle();
        return true;
    }

    @Override
    protected void executeAsync(Event e) {
        Path[] pathList;
        Path[] pathArray;
        if (this.isSingle) {
            Path[] pathArray2 = new Path[1];
            pathArray = pathArray2;
            pathArray2[0] = (Path)this.paths.getSingle(e);
        } else {
            pathArray = (Path[])this.paths.getArray(e);
        }
        for (Path path : pathList = pathArray) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            try {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                } else {
                    Files.delete(path);
                }
                new DeleteEvent(path);
                new ChangeEvent(path.getParent());
            }
            catch (IOException ex) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "delete " + this.paths.toString(e, debug);
    }

    static {
        EffDeleteFileDir.registerAsyncEffect(EffDeleteFileDir.class, "delete %path%");
    }
}

