/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.ChangeEvent;
import com.olyno.skent.skript.events.bukkit.CreateEvent;
import com.olyno.skent.util.AsyncEffect;
import com.olyno.skent.util.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.bukkit.event.Event;

@Name(value="Create File or directory")
@Description(value={"Creates a file or a directory. If the file exists, then it will be replaced by the new one."})
@Examples(value={"command create:\n\ttrigger:\n\t\tcreate file path \"plugins/Skript/scripts/myAwesomeScript.sk\" with text \"command awesome:\", \"\ttrigger:\" and \"\t\tbroadcast \"\"Awesome!!!\"\"\"\n\t\tbroadcast \"Created!\"", "# If you need to wait the end of the effect before execute a part of your code, you can\n# use this effect as a section effect.\n# The code after this effect section will be executed when the effect section has finished to be executed.\n\ncommand create:\n\ttrigger:\n\t\tcreate file path \"plugins/Skript/scripts/myAwesomeScript.sk\" with text \"command awesome:\", \"\ttrigger:\" and \"\t\tbroadcast \"\"Awesome!!!\"\"\":\n\t\t\tbroadcast \"Created!\""})
@Since(value="1.0")
public class EffCreateFileDir
extends AsyncEffect {
    private Expression<Path> paths;
    private Expression<String> content;
    private boolean isSingle;

    @Override
    protected boolean initAsync(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.paths = expr[0];
        this.isSingle = this.paths.getSource().isSingle();
        if (matchedPattern == 1) {
            this.content = expr[1];
        }
        return true;
    }

    @Override
    protected void executeAsync(Event e) {
        String[] stringArray;
        Path[] pathsList;
        Path[] pathArray;
        if (this.isSingle) {
            Path[] pathArray2 = new Path[1];
            pathArray = pathArray2;
            pathArray2[0] = (Path)this.paths.getSingle(e);
        } else {
            pathArray = pathsList = (Path[])this.paths.getArray(e);
        }
        if (this.content != null) {
            stringArray = (String[])this.content.getArray(e);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        String[] currentContent = stringArray;
        for (Path path : pathsList) {
            try {
                if (!Utils.isDirectory(path).booleanValue()) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    if (this.content != null) {
                        List<String> lines = Arrays.asList(currentContent);
                        Files.write(path, lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
                    } else if (!Files.exists(path, new LinkOption[0])) {
                        Files.createFile(path, new FileAttribute[0]);
                    }
                } else if (!Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                new CreateEvent(path, currentContent);
                new ChangeEvent(path.getParent());
            }
            catch (IOException ex) {
                if (Files.exists(path, new LinkOption[0])) continue;
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "create " + this.paths.toString(e, debug);
    }

    static {
        EffCreateFileDir.registerAsyncEffect(EffCreateFileDir.class, "create %paths%", "create %paths% with [(text|string|content)] %strings%");
    }
}

