/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.ChangeEvent;
import com.olyno.skent.util.AsyncEffect;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.bukkit.event.Event;

@Name(value="Appends Text File")
@Description(value={"Appends any text to a file."})
@Examples(value={"command append:\n\ttrigger:\n\t\tcreate file path \"plugins/Skript/scripts/test1.txt\" with \"My name is\"\n\t\tappend \"secret\" to file path \"plugins/Skript/scripts/test1.txt\"\n\t\tbroadcast \"The text has been added!\"", "# If you need to wait the end of the effect before execute a part of your code, you can\n# use this effect as a section effect.\n# The code after this effect section will be executed when the effect section has finished to be executed.\n\ncommand append:\n\ttrigger:\n\t\tcreate file path \"plugins/Skript/scripts/test1.txt\" with \"My name is\":\n\t\t\tappend \"secret\" to file path \"plugins/Skript/scripts/test1.txt\"\n\t\t\tbroadcast \"The text has been added!\""})
@Since(value="1.0")
public class EffAppendFile
extends AsyncEffect {
    private Expression<String> content;
    private Expression<Path> paths;
    private boolean isSingle;

    @Override
    protected boolean initAsync(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.content = expr[0];
        this.paths = expr[1];
        this.isSingle = this.paths.getSource().isSingle();
        return true;
    }

    @Override
    protected void executeAsync(Event e) {
        Path[] pathsList;
        Path[] pathArray;
        if (this.isSingle) {
            Path[] pathArray2 = new Path[1];
            pathArray = pathArray2;
            pathArray2[0] = (Path)this.paths.getSingle(e);
        } else {
            pathArray = (Path[])this.paths.getArray(e);
        }
        for (Path path : pathsList = pathArray) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            try {
                Files.write(path, Arrays.asList((String[])this.content.getArray(e)), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
                new ChangeEvent(path);
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "append " + this.content.toString(e, debug) + " to " + this.paths.toString(e, debug);
    }

    static {
        EffAppendFile.registerAsyncEffect(EffAppendFile.class, "append %strings% to %paths%");
    }
}

