/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.olyno.skent.util.PropertyPathCondition;
import java.nio.file.Files;
import java.nio.file.Path;

@Name(value="File is writable?")
@Description(value={"Checks if the file is writable or not."})
@Examples(value={"command readable:\n\ttrigger:\n\t\tif file path \"plugins/Skript/scripts/myAwesomeScript.sk\" is writable file:\n\t\t\tbroadcast \"Sure!\""})
@Since(value="1.0")
public class CondFileIsWritable
extends PropertyPathCondition<Path> {
    public boolean check(Path path) {
        return Files.isWritable(path);
    }

    protected String getPropertyName() {
        return "writable";
    }

    static {
        CondFileIsWritable.registerCondition(CondFileIsWritable.class, "writable", "path");
    }
}

