/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.olyno.skent.util.PriorityPropertyCondition;
import com.olyno.skent.util.Utils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Name(value="File is a file?")
@Description(value={"Checks if the file is a file or not."})
@Examples(value={"command file:\n\ttrigger:\n\t\tif file path \"plugins/Skript/scripts/myAwesomeScript.sk\" is a file:\n\t\t\tbroadcast \"Sure!\""})
@Since(value="1.0")
public class CondFileIsFile
extends PriorityPropertyCondition<Path> {
    public boolean check(Path path) {
        return Files.exists(path, new LinkOption[0]) ? Files.isRegularFile(path, new LinkOption[0]) : Utils.isDirectory(path) == false;
    }

    protected String getPropertyName() {
        return "file";
    }

    static {
        CondFileIsFile.registerCondition(CondFileIsFile.class, "[a] file", "path");
    }
}

