/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.bukkit.event.Event;

@Name(value="File or directory exists?")
@Description(value={"Checks if the file or directory exists or not."})
@Examples(value={"command exists:\n\ttrigger:\n\t\tif file path \"plugins/Skript/scripts/myAwesomeScript.sk\" is not missing:\n\t\t\tbroadcast \"Awesome!\""})
@Since(value="1.0")
public class CondFileExists
extends Condition {
    private Expression<Path> path;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.path = expr[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event e) {
        return this.isNegated() != Files.exists((Path)this.path.getSingle(e), new LinkOption[0]);
    }

    public String toString(Event e, boolean debug) {
        return this.path.toString(e, debug) + " is " + (this.isNegated() ? " missing" : " available");
    }

    static {
        Skript.registerCondition(CondFileExists.class, (String[])new String[]{"%path% (is available|is(n't| not) (missing|non[(-| )]existent))", "%path% (is (missing|non[(-| )]existent)|is(n't| not) available)"});
    }
}

