/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Name(value="Unallocated Space")
@Description(value={"Returns the unallocated space of a directory in bytes."})
@Examples(value={"command space:\n\ttrigger:\n\t\tset {_space} to unallocated space of directory path \"plugins/Skript\"\n\t\tbroadcast \"I should allocate more resource: %{_space}%\""})
@Since(value="2.0")
public class ExprUnallocatedSpace
extends SimplePropertyExpression<Path, Number> {
    public Number convert(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                FileStore store = Files.getFileStore(path);
                return store.getUnallocatedSpace();
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
        return 0;
    }

    protected String getPropertyName() {
        return "unallocated space";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprUnallocatedSpace.register(ExprUnallocatedSpace.class, Number.class, (String)"unallocated space", (String)"path");
    }
}

