/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.event.Event;

@Name(value="All File/Directory")
@Description(value={"Returns all files or directories in a dir."})
@Examples(value={"command allFiles:\n\ttrigger:\n\t\tset {_files::*} to all files of dir path \"plugins/Skript\"\n\t\tbroadcast \"Wow Skript has %amount of {_files::*}% files: %{_files::*}%\""})
@Since(value="1.0")
public class ExprAllFileDirectory
extends SimpleExpression<Path>
implements FileVisitor<Path> {
    private Expression<Path> path;
    private Expression<String> glob;
    private Path pathDirectory;
    private PathMatcher globPattern;
    private SearchFileType searchType;
    private List<Path> paths = new LinkedList<Path>();

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        switch (matchedPattern) {
            case 0: {
                this.searchType = SearchFileType.ALL_FILES_AND_DIRS;
                break;
            }
            case 1: {
                this.searchType = SearchFileType.ALL_FILES;
                break;
            }
            case 2: {
                this.searchType = SearchFileType.ALL_DIRS;
                break;
            }
            case 3: {
                this.searchType = SearchFileType.ALL_SUB_FILES_AND_DIRS;
                break;
            }
            case 4: {
                this.searchType = SearchFileType.ALL_SUB_DIRS;
                break;
            }
            case 5: {
                this.searchType = SearchFileType.ALL_SUB_FILES;
                break;
            }
            case 6: {
                this.searchType = SearchFileType.GLOBS;
                break;
            }
        }
        this.path = this.searchType == SearchFileType.GLOBS ? expr[1] : expr[0];
        this.glob = expr[0];
        return true;
    }

    protected Path[] get(Event e) {
        Path currentPath = (Path)this.path.getSingle(e);
        this.pathDirectory = Files.isDirectory(currentPath, new LinkOption[0]) ? currentPath : currentPath.getParent();
        this.globPattern = FileSystems.getDefault().getPathMatcher("glob:" + (this.searchType == SearchFileType.GLOBS ? (String)this.glob.getSingle(e) : ""));
        this.paths.clear();
        if (Files.exists(currentPath, new LinkOption[0])) {
            try {
                Files.walkFileTree(this.pathDirectory, this);
                return this.paths.toArray(new Path[0]);
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
        return new Path[0];
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (!dir.toString().equals(this.pathDirectory.toString())) {
            if (dir.getParent().toString().equals(this.pathDirectory.toString())) {
                if (this.searchType == SearchFileType.ALL_FILES_AND_DIRS || this.searchType == SearchFileType.ALL_DIRS) {
                    this.paths.add(dir);
                }
            } else if (this.searchType == SearchFileType.ALL_SUB_FILES_AND_DIRS || this.searchType == SearchFileType.ALL_SUB_DIRS) {
                this.paths.add(dir);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (!file.toString().equals(this.pathDirectory.toString())) {
            if (file.getParent().toString().equals(this.pathDirectory.toString())) {
                if (this.searchType == SearchFileType.ALL_FILES_AND_DIRS || this.searchType == SearchFileType.ALL_FILES) {
                    this.paths.add(file);
                }
            } else if (this.searchType == SearchFileType.ALL_SUB_FILES_AND_DIRS || this.searchType == SearchFileType.ALL_SUB_FILES) {
                this.paths.add(file);
            }
            if (this.searchType == SearchFileType.GLOBS && this.globPattern.matches(file)) {
                this.paths.add(file);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Path> getReturnType() {
        return Path.class;
    }

    public String toString(Event e, boolean debug) {
        switch (this.searchType) {
            case GLOBS: {
                return "glob files " + this.glob.toString(e, debug) + " in " + this.path.toString(e, debug);
            }
        }
        return this.searchType.toValue() + " of " + this.path.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprAllFileDirectory.class, Path.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"all [the] files and [all] [the] dir[ectorie]s (in|of|from) %path%", "all [the] files (in|of|from) %path%", "all [the] dir[ectorie]s (in|of|from) %path%", "all [the] sub[(-| )]files and [all] [the] sub[(-| )]dir[ectorie]s (in|of|from) %path%", "all [the] sub[(-| )]dir[ectorie]s (in|of|from) %path%", "all [the] sub[(-| )]files (in|of|from) %path%", "glob (files|dir[ectorie]s) %string% (in|of|from) %path%"});
    }

    private static enum SearchFileType {
        ALL_FILES_AND_DIRS("all files and dirs"),
        ALL_FILES("all files"),
        ALL_DIRS("all dirs"),
        ALL_SUB_FILES_AND_DIRS("all subfiles and subdirs"),
        ALL_SUB_FILES("all subfiles"),
        ALL_SUB_DIRS("all subdirs"),
        GLOBS("globs files");

        private String value;

        private SearchFileType(String value) {
            this.value = value;
        }

        private String toValue() {
            return this.value;
        }
    }
}

