/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.ChangeEvent;
import com.olyno.skent.skript.events.bukkit.RenameEvent;
import com.olyno.skent.util.AsyncEffect;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.bukkit.event.Event;

@Name(value="Rename File or directory")
@Description(value={"Renames a file or a directory."})
@Examples(value={"command rename:\n\ttrigger:\n\t\trename file path \"plugins/Skript/scripts/test1.txt\" to \"secret.txt\"\n\t\tbroadcast \"Now my file is secret!\"", "# If you need to wait the end of the effect before execute a part of your code, you can\n# use this effect as a section effect.# The code after this effect section will be executed when the effect section has finished to be executed.\n\ncommand rename:\n\ttrigger:\n\t\trename file path \"plugins/Skript/scripts/test1.txt\" to \"secret.txt\":\n\t\t\tbroadcast \"Now my file is secret!\""})
@Since(value="1.0")
public class EffRenameFileDir
extends AsyncEffect {
    private Expression<Path> paths;
    private Expression<String> name;
    private Boolean withReplace;
    private boolean isSingle;

    @Override
    protected boolean initAsync(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.paths = expr[0];
        this.name = expr[1];
        this.withReplace = matchedPattern == 1;
        this.isSingle = this.paths.getSource().isSingle();
        return true;
    }

    @Override
    protected void executeAsync(Event e) {
        Path[] pathArray;
        if (this.isSingle) {
            Path[] pathArray2 = new Path[1];
            pathArray = pathArray2;
            pathArray2[0] = (Path)this.paths.getSingle(e);
        } else {
            pathArray = (Path[])this.paths.getArray(e);
        }
        Path[] pathsList = pathArray;
        String currentName = (String)this.name.getSingle(e);
        for (Path path : pathsList) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            try {
                if (this.withReplace.booleanValue()) {
                    Files.move(path, path.resolveSibling(currentName), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.move(path, path.resolveSibling(currentName), new CopyOption[0]);
                }
                new RenameEvent(path, currentName);
                new ChangeEvent(path);
            }
            catch (IOException ex) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "rename " + this.paths.toString(e, debug) + " to " + this.name.toString(e, debug) + (this.withReplace != false ? " with" : " without") + " replace";
    }

    static {
        EffRenameFileDir.registerAsyncEffect(EffRenameFileDir.class, "rename %paths% to %string%", "rename %paths% to %string% with replace");
    }
}

