/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.olyno.skent.util.PropertyPathCondition;
import java.nio.file.Files;
import java.nio.file.Path;

@Name(value="File is readable?")
@Description(value={"Checks if the file is readable or not."})
@Examples(value={"command readable:\n\ttrigger:\n\t\tif file path \"plugins/Skript/scripts/myAwesomeScript.sk\" is readable file:\n\t\t\tbroadcast \"Sure!\""})
@Since(value="1.0")
public class CondFileIsReadable
extends PropertyPathCondition<Path> {
    public boolean check(Path path) {
        return Files.isReadable(path);
    }

    protected String getPropertyName() {
        return "readable";
    }

    static {
        CondFileIsReadable.registerCondition(CondFileIsReadable.class, "readable", "path");
    }
}

