/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.olyno.skent.util.PropertyPathCondition;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Name(value="File is hidden?")
@Description(value={"Checks if the file is hidden or not."})
@Examples(value={"command hidden:\n\ttrigger:\n\t\tif file path \"plugins/twitch.txt\" is hidden file:\n\t\t\tbroadcast \"I'm sneeeaaaakyy!\""})
@Since(value="1.0")
public class CondFileIsHidden
extends PropertyPathCondition<Path> {
    public boolean check(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return Files.isHidden(path);
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
        return false;
    }

    protected String getPropertyName() {
        return "hidden";
    }

    static {
        CondFileIsHidden.registerCondition(CondFileIsHidden.class, "hidden", "path");
    }
}

