/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.olyno.skent.util.PriorityPropertyCondition;
import com.olyno.skent.util.Utils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Name(value="File is a directory?")
@Description(value={"Checks if the file is a directory or not."})
@Examples(value={"command dir:\n\ttrigger:\n\t\tif file path \"plugins/Skript/scripts/myAwesomeScript.sk\" is a dir:\n\t\t\tbroadcast \"Nah!\""})
@Since(value="1.0")
public class CondFileIsDir
extends PriorityPropertyCondition<Path> {
    public boolean check(Path path) {
        return Files.exists(path, new LinkOption[0]) ? Files.isDirectory(path, new LinkOption[0]) : Utils.isDirectory(path);
    }

    protected String getPropertyName() {
        return "directory";
    }

    static {
        CondFileIsDir.registerCondition(CondFileIsDir.class, "[a] dir[ectory]", "path");
    }
}

