/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.google.common.io.Files;
import java.nio.file.Path;

@Name(value="Extension of File")
@Description(value={"Returns the extension of a file."})
@Examples(value={"command extension:\n\ttrigger:\n\t\tset {_extension} to extension of file \"plugins/Skript/config.sk\"\n\t\tbroadcast \"The extension of the config file is %{_extension}%\""})
@Since(value="1.0")
public class ExprExtension
extends SimplePropertyExpression<Path, String> {
    public String convert(Path file) {
        return Files.getFileExtension(file.toString());
    }

    protected String getPropertyName() {
        return "extension";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprExtension.register(ExprExtension.class, String.class, (String)"extension", (String)"path");
    }
}

