/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.event.Event;

@Name(value="Content from file")
@Description(value={"Returns the content of a file. Can be changed."})
@Examples(value={"command content:\n\ttrigger:\n\t\tset {_content::*} to content of file \"plugins/Skript/config.sk\"\n\t\tbroadcast \"Look that config:\"\n\t\tloop {_content::*}:\n\t\t\tbroadcast loop-value"})
@Since(value="1.0")
public class ExprContent
extends SimpleExpression<String> {
    private Expression<Path> file;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.file = expr[0];
        return true;
    }

    protected String[] get(Event e) {
        Path path = (Path)this.file.getSingle(e);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(path);
                return lines.toArray(new String[0]);
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[]{"This file doesn't exist: " + path});
            }
        }
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case ADD: 
            case REMOVE: {
                return new Class[]{String.class};
            }
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Path path = (Path)this.file.getSingle(e);
        try {
            LinkedList<String> edits = new LinkedList<String>();
            for (Object o : delta) {
                if (!(o instanceof String)) continue;
                edits.add((String)o);
            }
            switch (mode) {
                case SET: {
                    Files.write(path, edits, StandardCharsets.UTF_8, new OpenOption[0]);
                    break;
                }
                case ADD: {
                    Files.write(path, edits, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
                    break;
                }
                case REMOVE: {
                    LinkedList<String> newLines = new LinkedList<String>();
                    List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                    for (String edit : edits) {
                        for (String line : lines) {
                            if ((line = line.replaceAll(edit, "").trim()).isEmpty()) continue;
                            newLines.add(line);
                        }
                    }
                    Files.write(path, newLines, StandardCharsets.UTF_8, new OpenOption[0]);
                }
            }
        }
        catch (IOException ex) {
            Skript.exception((Throwable)ex, (String[])new String[]{"This file doesn't exist: " + path});
        }
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "content of " + this.file.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprContent.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] content of %path%", "[the] %path%'s content"});
    }
}

