/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.event.Event;

@Name(value="All File/Directory")
@Description(value={"Returns all files or directories in a dir."})
@Examples(value={"command allFiles:\n\ttrigger:\n\t\tset {_files::*} to all files of dir \"plugins/Skript\"\n\t\tbroadcast \"Wow Skript has %amount of {_files::*}% files: %{_files::*}%\""})
@Since(value="1.0")
public class ExprAllFileDirectory
extends SimpleExpression<Path>
implements FileVisitor<Path> {
    private Expression<Path> file;
    private Expression<String> glob;
    private Path path;
    private PathMatcher globPattern;
    private Boolean allFilesAndDirs = false;
    private Boolean allFiles = false;
    private Boolean allDirs = false;
    private Boolean allSubFilesAndSubDirs = false;
    private Boolean allSubDirs = false;
    private Boolean allSubFiles = false;
    private Boolean globFilesDirs = false;
    private List<Path> paths = new LinkedList<Path>();

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.allFilesAndDirs = matchedPattern == 0;
        this.allFiles = matchedPattern == 1;
        this.allDirs = matchedPattern == 2;
        this.allSubFilesAndSubDirs = matchedPattern == 3;
        this.allSubDirs = matchedPattern == 4;
        this.allSubFiles = matchedPattern == 5;
        this.globFilesDirs = matchedPattern == 6;
        this.file = this.globFilesDirs != false ? expr[1] : expr[0];
        this.glob = this.globFilesDirs != false ? expr[0] : null;
        return true;
    }

    protected Path[] get(Event e) {
        this.path = Files.isDirectory((Path)this.file.getSingle(e), new LinkOption[0]) ? (Path)this.file.getSingle(e) : ((Path)this.file.getSingle(e)).getParent();
        this.globPattern = FileSystems.getDefault().getPathMatcher("glob:" + (this.globFilesDirs != false ? (String)this.glob.getSingle(e) : ""));
        this.paths.clear();
        try {
            Files.walkFileTree(this.path, this);
            return this.paths.toArray(new Path[0]);
        }
        catch (IOException ex) {
            Skript.exception((Throwable)ex, (String[])new String[]{"This file doesn't exist: " + this.path.toString()});
            return null;
        }
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (!dir.toString().equals(this.path.toString())) {
            if (dir.getParent().toString().equals(this.path.toString())) {
                if (this.allFilesAndDirs.booleanValue() || this.allDirs.booleanValue()) {
                    this.paths.add(dir);
                }
            } else if (this.allSubFilesAndSubDirs.booleanValue() || this.allSubDirs.booleanValue()) {
                this.paths.add(dir);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (!file.toString().equals(this.path.toString())) {
            if (file.getParent().toString().equals(this.path.toString())) {
                if (this.allFilesAndDirs.booleanValue() || this.allFiles.booleanValue()) {
                    this.paths.add(file);
                }
            } else if (this.allSubFilesAndSubDirs.booleanValue() || this.allSubFiles.booleanValue()) {
                this.paths.add(file);
            }
            if (this.globFilesDirs.booleanValue() && this.globPattern.matches(file)) {
                this.paths.add(file);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Path> getReturnType() {
        return Path.class;
    }

    public String toString(Event e, boolean debug) {
        return null;
    }

    static {
        Skript.registerExpression(ExprAllFileDirectory.class, Path.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"all [the] files and [all] [the] dir[ectorie]s (in|of|from) %path%", "all [the] files (in|of|from) %path%", "all [the] dir[ectorie]s (in|of|from) %path%", "all [the] sub[(-| )]files and [all] [the] sub[(-| )]dir[ectorie]s (in|of|from) %path%", "all [the] sub[(-| )]dir[ectorie]s (in|of|from) %path%", "all [the] sub[(-| )]files (in|of|from) %path%", "glob (files|dir[ectorie]s) %string% (in|of|from) %path%"});
    }
}

