/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.CopyEvent;
import com.olyno.skent.util.AsyncEffect;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.bukkit.event.Event;

@Name(value="Copy File or directory")
@Description(value={"Copy a file or a directory to another."})
@Examples(value={"command copy:\n\ttrigger:\n\t\tcopy file \"plugins/Skript/scrips/MyAwesomeScript.sk\" to file \"plugins/Skript/scrips/MyAwesomeScriptCopy.sk\"\n\t\tbroadcast \"Copied!\""})
@Since(value="1.0")
public class EffCopyDir
extends AsyncEffect {
    private Expression<Path> source;
    private Expression<Path> target;
    private Boolean withReplace;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.source = expr[0];
        this.target = expr[1];
        this.withReplace = matchedPattern == 0;
        return true;
    }

    protected void execute(Event e) {
        Path sourceFile = (Path)this.source.getSingle(e);
        Path targetFile = (Path)this.target.getSingle(e);
        this.executeCode(e, () -> {
            try {
                if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                    this.copyFolder(sourceFile, targetFile);
                } else if (this.withReplace.booleanValue()) {
                    Files.copy(sourceFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(sourceFile, targetFile, new CopyOption[0]);
                }
                new CopyEvent((Path)this.source.getSingle(e), (Path)this.target.getSingle(e));
            }
            catch (IOException ex) {
                if (!Files.exists(sourceFile, new LinkOption[0])) {
                    Skript.exception((Throwable)ex, (String[])new String[]{"Source file or directory doesn't exist."});
                }
                if (Files.exists(targetFile, new LinkOption[0])) {
                    Skript.exception((Throwable)ex, (String[])new String[]{"Target file or directory already exist."});
                }
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        });
    }

    private void copyFolder(Path src, Path dest) throws IOException {
        Files.walk(src, new FileVisitOption[0]).forEach(source -> this.copy((Path)source, dest.resolve(src.relativize((Path)source))));
    }

    private void copy(Path source, Path dest) {
        try {
            if (this.withReplace.booleanValue()) {
                Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(source, dest, new CopyOption[0]);
            }
        }
        catch (Exception ex) {
            Skript.exception((Throwable)ex, (String[])new String[0]);
        }
    }

    public String toString(Event e, boolean debug) {
        return "copy " + this.source.toString(e, debug) + " to " + this.target.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCopyDir.class, (String[])new String[]{"copy %path% to %path% with replace", "copy %path% to %path%"});
    }
}

