/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Name(value="File is a directory?")
@Description(value={"Checks if the file is a directory or not."})
@Examples(value={"command dir:\n\ttrigger:\n\t\tif file \"plugins/Skript/scripts/myAwesomeScript.sk\" is a dir:\n\t\t\tbroadcast \"Nah!\""})
@Since(value="1.0")
public class CondFileIsDir
extends PropertyCondition<Path> {
    public boolean check(Path file) {
        return Files.isDirectory(file, new LinkOption[0]);
    }

    protected String getPropertyName() {
        return "directory";
    }

    static {
        PropertyCondition.register(CondFileIsDir.class, (String)"[a] dir[ectory]", (String)"path");
    }
}

