/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.RenameEvent;
import com.olyno.skent.util.AsyncEffect;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.bukkit.event.Event;

@Name(value="Rename File or directory")
@Description(value={"Renames a file or a directory."})
@Examples(value={"command rename:\n\ttrigger:\n\t\trename file \"plugins/Skript/scripts/test1.txt\" to \"secret.txt\"\n\t\tbroadcast \"Now my file is secret!\""})
@Since(value="1.0")
public class EffRenameFileDir
extends AsyncEffect {
    private Expression<Path> source;
    private Expression<String> name;
    private Boolean withReplace;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.source = expr[0];
        this.name = expr[1];
        this.withReplace = matchedPattern == 0;
        return true;
    }

    protected void execute(Event e) {
        Path currentSource = (Path)this.source.getSingle(e);
        String currentName = (String)this.name.getSingle(e);
        this.executeCode(e, () -> {
            try {
                if (this.withReplace.booleanValue()) {
                    Files.move(currentSource, currentSource.resolveSibling(currentName), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.move(currentSource, currentSource.resolveSibling(currentName), new CopyOption[0]);
                }
                new RenameEvent(currentSource, currentName);
            }
            catch (IOException ex) {
                if (!Files.exists(currentSource, new LinkOption[0])) {
                    Skript.exception((Throwable)ex, (String[])new String[]{"This file/directory doesn't exist: " + currentSource});
                }
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        });
    }

    public String toString(Event e, boolean debug) {
        return "rename " + this.source.toString(e, debug) + " to " + this.name.toString(e, debug) + (this.withReplace != false ? " with replace" : " without replace");
    }

    static {
        Skript.registerEffect(EffRenameFileDir.class, (String[])new String[]{"rename %path% to %string% with replace", "rename %path% to %string%"});
    }
}

