/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Name(value="File is a file?")
@Description(value={"Checks if the file is a file or not."})
@Examples(value={"command file:\n\ttrigger:\n\t\tif file \"plugins/Skript/scripts/myAwesomeScript.sk\" is a file:\n\t\t\tbroadcast \"Sure!\""})
@Since(value="1.0")
public class CondFileIsFile
extends PropertyCondition<Path> {
    public boolean check(Path file) {
        return !Files.isDirectory(file, new LinkOption[0]);
    }

    protected String getPropertyName() {
        return "file";
    }

    static {
        PropertyCondition.register(CondFileIsFile.class, (String)"[a] file", (String)"path");
    }
}

