/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.expressions.ExprFileDirectory;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.bukkit.event.Event;

@Name(value="File or directory exists?")
@Description(value={"Checks if the file or directory exists or not."})
@Examples(value={"command exists:\n\ttrigger:\n\t\tif file \"plugins/Skript/scripts/myAwesomeScript.sk\" exists:\n\t\t\tbroadcast \"Awesome!\""})
@Since(value="1.0")
public class CondFileExists
extends Condition {
    private Expression<?> file;

    private static <E extends Condition> void registerCondition(Class<E> condition, String ... patterns) {
        try {
            String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
            SyntaxElementInfo info = new SyntaxElementInfo(patterns, condition, originClassPath);
            Field field = Skript.class.getDeclaredField("conditions");
            field.setAccessible(true);
            ArrayList o = (ArrayList)field.get(Skript.class);
            o.add(0, info);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (parseResult.mark == 1 && expr[0] instanceof ExprFileDirectory) {
            return false;
        }
        if (parseResult.mark == 0 && !(expr[0] instanceof ExprFileDirectory)) {
            return false;
        }
        this.file = expr[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event e) {
        Path path;
        Object f = this.file.getSingle(e);
        Path path2 = path = f instanceof String ? Paths.get((String)f, new String[0]) : (Path)((ExprFileDirectory)this.file).getSingle(e);
        if (this.isNegated()) {
            return !Files.exists(path, new LinkOption[0]);
        }
        return Files.exists(path, new LinkOption[0]);
    }

    public String toString(Event e, boolean debug) {
        return this.file.toString(e, debug) + (this.isNegated() ? " doesn't exist" : " exists");
    }

    static {
        CondFileExists.registerCondition(CondFileExists.class, "[(1\u00a6file[s]|dir[ectory])] %string/path% (exist[s]|(is|are) set)", "[(1\u00a6file[s]|dir[ectory])] %string/path% (do[es](n't| not) exist|(is|are)(n't| not) set)");
    }
}

