/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.olyno.skent.util.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicLong;

@Name(value="Size of File/Directory")
@Description(value={"Returns the size of a file or a directory."})
@Examples(value={"command size:\n\ttrigger:\n\t\tset {_size} to size of file \"plugins/Skript/config.sk\"\n\t\tbroadcast \"The size of the config file is %{_extension}%\""})
@Since(value="1.0")
public class ExprSize
extends SimplePropertyExpression<Path, String> {
    private static final long ONE_KB = 1024L;
    private static final BigInteger ONE_KB_BI = BigInteger.valueOf(1024L);
    private static final long ONE_MB = 0x100000L;
    private static final BigInteger ONE_MB_BI = ONE_KB_BI.multiply(ONE_KB_BI);
    private static final long ONE_GB = 0x40000000L;
    private static final BigInteger ONE_GB_BI = ONE_KB_BI.multiply(ONE_MB_BI);
    private static final long ONE_TB = 0x10000000000L;
    private static final BigInteger ONE_TB_BI = ONE_KB_BI.multiply(ONE_GB_BI);
    private static final long ONE_PB = 0x4000000000000L;
    private static final BigInteger ONE_PB_BI = ONE_KB_BI.multiply(ONE_TB_BI);
    private static final long ONE_EB = 0x1000000000000000L;
    private static final BigInteger ONE_EB_BI = ONE_KB_BI.multiply(ONE_PB_BI);
    private static final BigInteger ONE_ZB = BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x1000000000000000L));
    private static final BigInteger ONE_YB = ONE_KB_BI.multiply(ONE_ZB);

    public String convert(Path file) {
        try {
            final AtomicLong size = new AtomicLong(0L);
            if (!Utils.isDirectory(file).booleanValue()) {
                size.addAndGet(FileChannel.open(file, new OpenOption[0]).size());
            } else {
                Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        size.addAndGet(attrs.size());
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return this.byteCountToDisplaySize(BigInteger.valueOf(size.intValue()));
        }
        catch (IOException e) {
            return null;
        }
    }

    private String byteCountToDisplaySize(BigInteger size) {
        String displaySize = size.divide(ONE_EB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(size.divide(ONE_EB_BI)) + " EB" : (size.divide(ONE_PB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(size.divide(ONE_PB_BI)) + " PB" : (size.divide(ONE_TB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(size.divide(ONE_TB_BI)) + " TB" : (size.divide(ONE_GB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(size.divide(ONE_GB_BI)) + " GB" : (size.divide(ONE_MB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(size.divide(ONE_MB_BI)) + " MB" : (size.divide(ONE_KB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(size.divide(ONE_KB_BI)) + " KB" : String.valueOf(size) + " bytes")))));
        return displaySize;
    }

    protected String getPropertyName() {
        return "size";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprSize.register(ExprSize.class, String.class, (String)"[the] size", (String)"path");
    }
}

