/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.bukkit.event.Event;

@Name(value="Line of file")
@Description(value={"Returns a specific line of a file."})
@Examples(value={"command line:\n\ttrigger:\n\t\tset line 1 of file \"plugins/Skript/scripts/myAwesomeScript.sk\" to \"command awesometest\"\n\t\tadd \":\" to line 1 of file \"plugins/Skript/scripts/myAwesomeScript.sk\"\n\t\tremove \"test\" from line 1 of file \"plugins/Skript/scripts/myAwesomeScript.sk\"\n\t\tbroadcast line 1 of file \"plugins/Skript/scripts/myAwesomeScript.sk\""})
@Since(value="1.0")
public class ExprLine
extends SimpleExpression<String> {
    private Expression<Number> line;
    private Expression<Path> file;
    private Boolean allLines = false;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.line = expr[0];
            this.file = expr[1];
        } else {
            this.file = expr[0];
            this.allLines = true;
        }
        return true;
    }

    protected String[] get(Event e) {
        int theLine;
        Path path = (Path)this.file.getSingle(e);
        int n = theLine = this.line != null ? ((Number)this.line.getSingle(e)).intValue() : 0;
        if (Files.exists(path, new LinkOption[0])) {
            try {
                if (this.allLines.booleanValue()) {
                    return Files.readAllLines(path).toArray(new String[0]);
                }
                return new String[]{Files.lines(path).skip(theLine - 1).findFirst().get()};
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[]{"This file doesn't exist: " + path});
            }
        }
        return null;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case ADD: 
            case REMOVE: {
                return new Class[]{String.class};
            }
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Path path = (Path)this.file.getSingle(e);
        try {
            int theLine = this.line != null ? ((Number)this.line.getSingle(e)).intValue() : 0;
            List<String> lines = Files.readAllLines((Path)this.file.getSingle(e), StandardCharsets.UTF_8);
            if (lines.size() < theLine) {
                for (int i = lines.size(); i < theLine; ++i) {
                    lines.add("");
                }
            }
            switch (mode) {
                case SET: {
                    lines.set(theLine - 1, (String)delta[0]);
                    break;
                }
                case ADD: {
                    lines.set(theLine - 1, lines.get(theLine - 1) + delta[0]);
                    break;
                }
                case REMOVE: {
                    lines.set(theLine - 1, lines.get(theLine - 1).replaceAll((String)delta[0], ""));
                }
            }
            Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException ex) {
            Skript.exception((Throwable)ex, (String[])new String[]{"This file doesn't exist: " + path});
        }
    }

    public boolean isSingle() {
        return this.allLines == false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return (this.allLines != false ? "all lines" : "line " + this.line.toString(e, debug)) + " of " + this.file.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprLine.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] line %integer% (from|of|in) %path%", "[all] [the] lines (from|of|in) %path%"});
    }
}

