/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.DeleteEvent;
import com.olyno.skent.util.AsyncEffect;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.bukkit.event.Event;

@Name(value="Delete File or directory")
@Description(value={"Deletes a file or a directory."})
@Examples(value={"command delete:\n\ttrigger:\n\t\tdelete file \"plugins/Skript/scripts/myAwesomeScript.sk\"\n\t\tbroadcast \"Oh no, my awesome script!\""})
@Since(value="1.0")
public class EffDeleteFileDir
extends AsyncEffect {
    private Expression<Path> file;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.file = expr[0];
        return true;
    }

    protected void execute(Event e) {
        Path path = (Path)this.file.getSingle(e);
        this.executeCode(e, () -> {
            try {
                Files.deleteIfExists(path);
                new DeleteEvent(path);
            }
            catch (IOException ex) {
                if (Files.exists(path, new LinkOption[0])) {
                    Skript.exception((Throwable)ex, (String[])new String[]{"This file/directory doesn't exist: " + path});
                }
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        });
    }

    public String toString(Event e, boolean debug) {
        return "delete " + this.file.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffDeleteFileDir.class, (String[])new String[]{"delete %path%"});
    }
}

