/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.CreateEvent;
import com.olyno.skent.util.AsyncEffect;
import com.olyno.skent.util.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.bukkit.event.Event;

@Name(value="Create File or directory")
@Description(value={"Creates a file or a directory. If the file exists, then it will be replaced by the new one."})
@Examples(value={"command create:\n\ttrigger:\n\t\tcreate file \"plugins/Skript/scripts/myAwesomeScript.sk\" with text \"command awesome:\", \"\ttrigger:\" and \"\t\tbroadcast \"\"Awesome!!!\"\"\"\n\t\tbroadcast \"Created!\""})
@Since(value="1.0")
public class EffCreateFileDir
extends AsyncEffect {
    private Expression<Path> file;
    private Expression<String> content;
    private Boolean withContent = false;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.file = expr[0];
        if (matchedPattern == 0) {
            this.content = expr[1];
            this.withContent = true;
        }
        return true;
    }

    protected void execute(Event e) {
        String[] stringArray;
        Path path = (Path)this.file.getSingle(e);
        if (this.content != null) {
            stringArray = (String[])this.content.getArray(e);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        String[] currentContent = stringArray;
        this.executeCode(e, () -> {
            try {
                if (!Utils.isDirectory(path).booleanValue()) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    if (this.withContent.booleanValue()) {
                        List<String> lines = Arrays.asList(currentContent);
                        Files.write(path, lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
                    } else if (!Files.exists(path, new LinkOption[0])) {
                        Files.createFile(path, new FileAttribute[0]);
                    }
                } else if (!Files.exists(path, new LinkOption[0])) {
                    Files.createDirectory(path, new FileAttribute[0]);
                }
                new CreateEvent(path, currentContent);
            }
            catch (IOException ex) {
                if (Files.exists(path, new LinkOption[0])) {
                    Skript.exception((Throwable)ex, (String[])new String[]{"This file/directory already exists: " + path});
                }
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        });
    }

    public String toString(Event e, boolean debug) {
        return "create " + this.file.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffCreateFileDir.class, (String[])new String[]{"create %path% with [(text|string|content)] %strings%", "create %path%"});
    }
}

