/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.UnzipEvent;
import com.olyno.skent.util.AsyncEffect;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.bukkit.event.Event;

@Name(value="Unzip File or Directory")
@Description(value={"Unzips files and/or directories."})
@Examples(value={"command unzip:\n\ttrigger:\n\t\tunzip all files in file \"plugins/Skript/scripts.zip\" to dir \"plugins/Skript\"\n\t\tbroadcast \"Nice I retrieved my backup!\""})
@Since(value="1.0")
public class EffUnzipFileDir
extends AsyncEffect {
    private Expression<Path> files;
    private Expression<Path> source;
    private Expression<Path> target;
    private Expression<String> password;
    private Boolean allFiles = false;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        int index = 0;
        if (matchedPattern == 0 || matchedPattern == 1) {
            this.allFiles = true;
            ++index;
        } else {
            this.files = expr[0];
        }
        this.source = expr[1 - index];
        this.target = expr[2 - index];
        if (matchedPattern == 0 || matchedPattern == 2) {
            this.password = expr[3 - index];
        }
        return true;
    }

    protected void execute(Event e) {
        String pass;
        Path sourceFile = (Path)this.source.getSingle(e);
        Path targetFile = (Path)this.target.getSingle(e);
        String string = pass = this.password != null ? (String)this.password.getSingle(e) : null;
        if (!Pattern.compile("\\.zip$").matcher(sourceFile.toString()).find()) {
            return;
        }
        this.executeCode(e, () -> this.unzip(this.files != null ? (Path[])this.files.getArray(e) : null, (Path)this.source.getSingle(e), (Path)this.target.getSingle(e), pass));
    }

    private void unzip(Path[] allFiles, Path src, Path dest, String pass) {
        try {
            ZipFile zipFile;
            if (!Files.exists(dest, new LinkOption[0])) {
                Files.createDirectory(dest, new FileAttribute[0]);
            }
            if ((zipFile = new ZipFile(src.toString())).isEncrypted() && pass != null) {
                zipFile.setPassword(pass);
            }
            if (allFiles == null) {
                zipFile.extractAll(dest.toString());
            } else {
                for (Path file : allFiles) {
                    zipFile.extractFile(file.toString(), dest.toString());
                }
            }
            new UnzipEvent(allFiles, src, dest, pass);
        }
        catch (IOException | ZipException ex) {
            Skript.exception((Throwable)ex, (String[])new String[0]);
        }
    }

    public String toString(Event e, boolean debug) {
        return "unzip " + (this.allFiles != false ? " all files " : this.files.toString(e, debug)) + "in " + this.source.toString(e, debug) + " to " + this.target.toString(e, debug) + (this.password != null ? " with password " + this.password.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffUnzipFileDir.class, (String[])new String[]{"(unzip|extract) all files (in|of|from) %path% to %path% with [password] %string%", "(unzip|extract) all files (in|of|from) %path% to %path%", "(unzip|extract) %path% (in|of|from) %path% to %path% with [password] %string%", "(unzip|extract) %path% (in|of|from) %path% to %path%"});
    }
}

