/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skent.skript.events.bukkit.MoveEvent;
import com.olyno.skent.util.AsyncEffect;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.bukkit.event.Event;

@Name(value="Move File or directory")
@Description(value={"Moves a file or a directory."})
@Examples(value={"command move:\n\ttrigger:\n\t\tmove file \"plugins/Skript/config.sk\" to file \"plugins/config.sk\"\n\t\tbroadcast \"Got a new config!\""})
@Since(value="1.0")
public class EffMoveFileDir
extends AsyncEffect {
    private Expression<Path> source;
    private Expression<Path> target;
    private Boolean withReplace = false;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.source = expr[0];
        this.target = expr[1];
        this.withReplace = matchedPattern == 0;
        return true;
    }

    protected void execute(Event e) {
        Path sourceFile = (Path)this.source.getSingle(e);
        Path targetFile = (Path)this.target.getSingle(e);
        this.executeCode(e, () -> {
            try {
                if (this.withReplace.booleanValue()) {
                    Files.move(sourceFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.move(sourceFile, targetFile, new CopyOption[0]);
                }
                new MoveEvent(sourceFile, targetFile);
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        });
    }

    public String toString(Event e, boolean debug) {
        return "move " + this.source.toString(e, debug) + " to " + this.target.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffMoveFileDir.class, (String[])new String[]{"move %path% to %path% with replace", "move %path% to %path%"});
    }
}

