/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skent.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import java.nio.file.Files;
import java.nio.file.Path;

@Name(value="File is readable?")
@Description(value={"Checks if the file is readable or not."})
@Examples(value={"command readable:\n\ttrigger:\n\t\tif file \"plugins/Skript/scripts/myAwesomeScript.sk\" is readable:\n\t\t\tbroadcast \"Sure!\""})
@Since(value="1.0")
public class CondFileIsReadable
extends PropertyCondition<Path> {
    public boolean check(Path file) {
        return Files.isReadable(file);
    }

    protected String getPropertyName() {
        return "readable";
    }

    static {
        PropertyCondition.register(CondFileIsReadable.class, (String)"readable", (String)"path");
    }
}

