/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import org.bukkit.event.Event;

@Name(value="File/Directory")
@Description(value={"Returns a file or directory from its path. Can return a list of file."})
@Examples(value={"command create:\n\ttrigger:\n\t\tcreate file \"plugins/Skript/scripts/test1.txt\" with \"hey\", \"just\", \"a\" and \"test\"\n\t\tremove \"hey\" from file \"plugins/Skript/scripts/test1.txt\"\n\t\tadd \"with Skent\" to file \"plugins/Skript/scripts/test1.txt\"\n\t\tbroadcast \"Finished!\""})
@Since(value="1.0")
public class ExprFileDirectory
extends SimpleExpression<Path> {
    private Expression<String> path;
    private boolean isSingle = true;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.path = expr[0];
        this.isSingle = expr.length == 1;
        return true;
    }

    protected Path[] get(Event e) {
        LinkedList<Path> files = new LinkedList<Path>();
        for (String p : (String[])this.path.getArray(e)) {
            files.add(Paths.get(p, new String[0]));
        }
        return files.toArray(new Path[0]);
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Class<? extends Path> getReturnType() {
        return Path.class;
    }

    public String toString(Event e, boolean debug) {
        return "file " + this.path.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprFileDirectory.class, Path.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (file[s]|dir[ector(y|ies)]) %string%"});
    }
}

