/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.bukkit.event.Event;

@Name(value="Content from url")
@Description(value={"Returns the content of a url."})
@Examples(value={"command content:\n\ttrigger:\n\t\tset {_content} to content from url \"https://raw.githubusercontent.com/SkriptLang/Skript/master/README.md\"\n\t\tbroadcast \"Yep, it's the README of Skript's github:\"\n\t\tbroadcast {_content}"})
@Since(value="1.0")
public class ExprContentFromURL
extends SimpleExpression<String> {
    private Expression<String> url;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.url = expr[0];
        return true;
    }

    protected String[] get(Event e) {
        try {
            return new String[]{this.readToString((String)this.url.getSingle(e))};
        }
        catch (IOException ex) {
            Skript.exception((Throwable)ex, (String[])new String[0]);
            return null;
        }
    }

    private String readToString(String targetURL) throws IOException {
        String inputLine;
        URL url = new URL(targetURL);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
        StringBuilder stringBuilder = new StringBuilder();
        while ((inputLine = bufferedReader.readLine()) != null) {
            stringBuilder.append(inputLine);
            stringBuilder.append(System.lineSeparator());
        }
        bufferedReader.close();
        return stringBuilder.toString().trim();
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "content from " + this.url.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprContentFromURL.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] content from url %string%"});
    }
}

