/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.event.Event;

@Name(value="All File/Directory")
@Description(value={"Returns all files or directories in a dir."})
@Examples(value={"command allFiles:\n\ttrigger:\n\t\tset {_files::*} to all files of \"plugins/Skript\"\n\t\tbroadcast \"Wow Skript has %amount of {_files::*}% files: %{_files::*}%\""})
@Since(value="1.0")
public class ExprAllFileDirectory
extends SimpleExpression<Path>
implements FileVisitor<Path> {
    private Expression<Path> file;
    private Path parent;
    private Boolean allFiles;
    private Boolean includingSubDirs;
    private Boolean includingSubFiles;
    private Boolean includingSubDirsAndFiles;
    private List<Path> files = new LinkedList<Path>();

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.file = expr[0];
        this.includingSubDirsAndFiles = matchedPattern == 0;
        this.includingSubDirs = matchedPattern == 1;
        this.includingSubFiles = matchedPattern == 2;
        this.allFiles = matchedPattern == 4;
        return true;
    }

    protected Path[] get(Event e) {
        Path path = (Path)this.file.getSingle(e);
        try {
            if (Files.exists(path, new LinkOption[0])) {
                this.parent = Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
            }
            Files.walkFileTree(path, this);
            return this.files.toArray(new Path[0]);
        }
        catch (IOException ex) {
            Skript.exception((Throwable)ex, (String[])new String[0]);
            return null;
        }
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (!dir.equals(this.parent)) {
            if (!this.allFiles.booleanValue()) {
                if (this.includingSubDirsAndFiles.booleanValue() || this.includingSubDirs.booleanValue()) {
                    this.files.add(dir);
                    return FileVisitResult.CONTINUE;
                }
                if (this.parent.equals(dir.getParent())) {
                    this.files.add(dir);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.allFiles.booleanValue() && (this.includingSubDirsAndFiles.booleanValue() || this.includingSubFiles.booleanValue() || this.parent.equals(file.getParent()))) {
            this.files.add(file);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (this.includingSubDirsAndFiles.booleanValue() || this.includingSubDirs.booleanValue() || this.includingSubFiles.booleanValue() || dir.equals(this.parent)) {
            return FileVisitResult.CONTINUE;
        }
        return FileVisitResult.TERMINATE;
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Path> getReturnType() {
        return Path.class;
    }

    public String toString(Event e, boolean debug) {
        return "all " + (this.allFiles != false ? " files " : " directories ") + "in " + this.file.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprAllFileDirectory.class, Path.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"all [the] dir[ector(y|ie)]s (in|of) %path% (including|with) [all] sub[(-| )]dir[ectorie]s and [all] sub(-| )files", "all [the] dir[ector(y|ie)]s (in|of) %path% (including|with) [all] sub[(-| )]dir[ectorie]s", "all [the] dir[ector(y|ie)]s (in|of) %path% (including|with) [all] sub[(-| )]files", "all [the] dir[ector(y|ie)]s (in|of) %path%", "all [the] files (in|of) %path%"});
    }
}

