/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.nio.file.Path;

@Name(value="Absolute path")
@Description(value={"Returns the absolute path of a file."})
@Examples(value={"command absolute:\n\ttrigger:\n\t\tset {_path} to absolute path of file \"plugins/Skript/config.sk\"\n\t\tbroadcast \"The path of the config file is %{_path}%\""})
@Since(value="1.0")
public class ExprAbsolutePath
extends SimplePropertyExpression<Path, String> {
    public String convert(Path file) {
        return file.toAbsolutePath().toString();
    }

    protected String getPropertyName() {
        return "absolute path";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprAbsolutePath.register(ExprAbsolutePath.class, String.class, (String)"[the] absolute path", (String)"path");
    }
}

