/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skript.events.bukkit.ExecuteEvent;
import com.olyno.util.AsyncEffect;
import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="Run/Execute File")
@Description(value={"Runs/Executes a file."})
@Examples(value={"command execute:\n\ttrigger:\n\t\texecute file \"plugins/myAwesomeBat.bat\"\n\t\tbroadcast \"File executed! I'm now a hacker!\""})
@Since(value="1.0")
public class EffExecuteFile
extends AsyncEffect {
    private Expression<Path> file;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.file = expr[0];
        return true;
    }

    protected void execute(Event e) {
        this.launchApp((Path)this.file.getSingle(e));
    }

    private void launchApp(Path app) {
        if (Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            try {
                Desktop.getDesktop().open(app.toFile());
                Bukkit.getServer().getPluginManager().callEvent((Event)new ExecuteEvent(app));
            }
            catch (IOException ex) {
                if (Files.exists(app, new LinkOption[0])) {
                    Skript.exception((Throwable)ex, (String[])new String[]{"This file doesn't exist: " + app});
                }
                Skript.exception((Throwable)ex, (String[])new String[0]);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "execute " + this.file.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffExecuteFile.class, (String[])new String[]{"(execute|run) %path%"});
    }
}

