/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import java.nio.file.Files;
import java.nio.file.Path;

@Name(value="File is executable?")
@Description(value={"Checks if the file executable or not."})
@Examples(value={"command executable:\n\ttrigger:\n\t\tif file \"plugins/Skript/scripts/myAwesomeGame.exe\" is executable:\n\t\t\tbroadcast \"Oh, probably a game!\""})
@Since(value="1.0")
public class CondFileIsExecutable
extends PropertyCondition<Path> {
    public boolean check(Path file) {
        return Files.isExecutable(file);
    }

    protected String getPropertyName() {
        return "executable";
    }

    static {
        PropertyCondition.register(CondFileIsExecutable.class, (String)"[a[n]] exe[cutable]", (String)"path");
    }
}

