/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Name(value="Owner of File/Directory")
@Description(value={"Returns the owner of a file or directory."})
@Examples(value={"command owner:\n\ttrigger:\n\t\tset {_owner} to owner of file \"plugins/Skript/config.sk\"\n\t\tbroadcast \"Hey boi, look I'm my computer is the owner: %{_owner}%\""})
@Since(value="1.0")
public class ExprOwner
extends SimplePropertyExpression<Path, String> {
    public String convert(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return Files.getOwner(file, new LinkOption[0]).getName();
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[]{"This file doesn't exist: " + file});
            }
        }
        return null;
    }

    protected String getPropertyName() {
        return "owner";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprOwner.register(ExprOwner.class, String.class, (String)"[the] owner", (String)"path");
    }
}

