/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import com.olyno.skript.events.bukkit.WatchingFileEvent;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

@Name(value="Watching File/Directory")
@Description(value={"Watching all changes of a directory or a file (save, delete...)"})
@Examples(value={""})
@Since(value="1.0")
public class EvtWatchingFile
extends SelfRegisteringSkriptEvent {
    private static Path path;
    private static int taskID;
    private Trigger t;

    private static void registerListener() {
        if (taskID != -1) {
            return;
        }
        taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Skript.getInstance(), () -> {
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    WatchService watchService = FileSystems.getDefault().newWatchService();
                    WatchKey key = path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                    while (true) {
                        EvtWatchingFile next = new EvtWatchingFile();
                        key = watchService.take();
                        for (WatchEvent<?> event : key.pollEvents()) {
                            Path file = (Path)event.context();
                            next.execute(file, event.kind().name());
                        }
                        key.reset();
                    }
                }
                catch (IOException | InterruptedException ex) {
                    Skript.exception((Throwable)ex, (String[])new String[0]);
                }
            }
        }, 0L, 0L);
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        path = (Path)args[0].getSingle();
        return true;
    }

    void execute(Path file, String kind) {
        Trigger t = this.t;
        if (t == null) {
            assert (false);
            return;
        }
        WatchingFileEvent e = new WatchingFileEvent(file, kind);
        SkriptEventHandler.logEventStart((Event)e);
        SkriptEventHandler.logTriggerEnd((Trigger)t);
        t.execute((Event)e);
        SkriptEventHandler.logTriggerEnd((Trigger)t);
        SkriptEventHandler.logEventEnd();
    }

    public void register(Trigger t) {
        this.t = t;
        EvtWatchingFile.registerListener();
    }

    public void unregister(Trigger t) {
        assert (t == this.t);
        this.t = null;
    }

    public void unregisterAll() {
        if (taskID != -1) {
            Bukkit.getScheduler().cancelTask(taskID);
        }
        this.t = null;
        taskID = -1;
    }

    public String toString(Event e, boolean debug) {
        return "watching " + path;
    }

    static {
        taskID = -1;
        Skript.registerEvent((String)"Watching file", EvtWatchingFile.class, WatchingFileEvent.class, (String[])new String[]{"watching %file%"});
        EventValues.registerEventValue(WatchingFileEvent.class, String.class, (Getter)new Getter<String, WatchingFileEvent>(){

            public String get(WatchingFileEvent e) {
                return e.getKind();
            }
        }, (int)0);
        EventValues.registerEventValue(WatchingFileEvent.class, Path.class, (Getter)new Getter<Path, WatchingFileEvent>(){

            public Path get(WatchingFileEvent e) {
                return e.getFile();
            }
        }, (int)0);
    }
}

