/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skript.events.bukkit.ZipEvent;
import com.olyno.util.AsyncEffect;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="Zip File or Directory")
@Description(value={"Zips files and/or directories."})
@Examples(value={"command zip:\n\ttrigger:\n\t\tzip dir \"plugins/Skript/scripts\" to dir \"plugins/Skript/scripts.zip\"\n\t\tbroadcast \"Nice I did a backup!\""})
@Since(value="1.0")
public class EffZipFileDir
extends AsyncEffect {
    private Expression<Path> source;
    private Expression<Path> target;
    private Expression<String> password;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.source = expr[0];
        this.target = expr[1];
        if (matchedPattern == 0) {
            this.password = expr[2];
        }
        return true;
    }

    protected void execute(Event e) {
        String pass;
        Path[] sourceFile = (Path[])this.source.getArray(e);
        Path targetFile = (Path)this.target.getSingle(e);
        String string = pass = this.password != null ? (String)this.password.getSingle(e) : null;
        if (Pattern.compile("\\.zip$").matcher(targetFile.toString()).find()) {
            if (this.password != null && pass != null) {
                this.zip(sourceFile, targetFile, pass);
            } else {
                this.zip(sourceFile, targetFile, null);
            }
        }
    }

    private void zip(Path[] src, Path dest, String pass) {
        try {
            ZipFile zipFile = new ZipFile(dest.toString());
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(9);
            if (pass != null) {
                parameters.setEncryptFiles(true);
                parameters.setEncryptionMethod(0);
                parameters.setAesKeyStrength(1);
                parameters.setPassword(pass);
            }
            for (Path file : src) {
                if (!Files.exists(file, new LinkOption[0])) continue;
                if (Files.isDirectory(file, new LinkOption[0])) {
                    zipFile.addFolder(file.toString(), parameters);
                    continue;
                }
                zipFile.addFile(file.toFile(), parameters);
            }
            Bukkit.getServer().getPluginManager().callEvent((Event)new ZipEvent(src, dest, pass));
        }
        catch (ZipException ex) {
            Skript.exception((Throwable)ex, (String[])new String[0]);
        }
    }

    public String toString(Event e, boolean debug) {
        return "zip " + this.source.toString(e, debug) + " to " + this.target.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffZipFileDir.class, (String[])new String[]{"zip %paths% to %path% with [password] %string%", "zip %paths% to %path%"});
    }
}

