/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.util.AsyncEffect;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.bukkit.event.Event;

@Name(value="Insert Line")
@Description(value={"Inserts a line in a file."})
@Examples(value={"command insert:\n\ttrigger:\n\t\tcreate file \"plugins/Skript/scripts/test1.txt\" with text \"Hey\", \"I'm\" and \"nice to meet you!\"\n\t\tinsert \"the creator\" at line 2 of file \"plugins/Skript/scripts/test1.txt\"\n\t\tbroadcast \"Of course I'm the creator!\""})
@Since(value="1.0")
public class EffInsertLine
extends AsyncEffect {
    private Expression<String> content;
    private Expression<Integer> line;
    private Expression<Path> file;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.content = expr[0];
        this.line = expr[1];
        this.file = expr[2];
        return true;
    }

    protected void execute(Event e) {
        Path path = (Path)this.file.getSingle(e);
        try {
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            lines.add((Integer)this.line.getSingle(e), (String)this.content.getSingle(e));
            Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException ex) {
            if (Files.exists(path, new LinkOption[0])) {
                Skript.exception((Throwable)ex, (String[])new String[]{"This file doesn't exist: " + path});
            }
            Skript.exception((Throwable)ex, (String[])new String[0]);
        }
    }

    public String toString(Event e, boolean debug) {
        return "insert \"" + this.content.toString(e, debug) + "\" at line " + this.line.toString(e, debug) + " of " + this.file.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffInsertLine.class, (String[])new String[]{"insert %strings% at line %integer% of %path%"});
    }
}

