/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skript.events.bukkit.DownloadEvent;
import com.olyno.util.AsyncEffect;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="Download File")
@Description(value={"Downloads a file from a url."})
@Examples(value={"command download:\n\ttrigger:\n\t\tdownload from url \"https://bitbucket.org/AlexLew95/skent/downloads/Skent-1.0-all.jar\" to file \"plugins/Skent.jar\"\n\t\tbroadcast \"Skent downloaded!\""})
@Since(value="1.0")
public class EffDownloadFile
extends AsyncEffect {
    private Expression<String> url;
    private Expression<Path> file;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.url = expr[0];
        this.file = expr[1];
        return true;
    }

    protected void execute(Event e) {
        this.download((String)this.url.getSingle(e), (Path)this.file.getSingle(e));
    }

    private void download(String url, Path output) {
        try {
            ReadableByteChannel rbc = Channels.newChannel(new URL(url).openStream());
            FileOutputStream fos = new FileOutputStream(output.toString());
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            rbc.close();
            Bukkit.getServer().getPluginManager().callEvent((Event)new DownloadEvent(url, output));
        }
        catch (IOException ex) {
            Skript.exception((Throwable)ex, (String[])new String[0]);
        }
    }

    public String toString(Event e, boolean debug) {
        return "download file from " + this.url.toString(e, debug) + " to file " + this.file.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffDownloadFile.class, (String[])new String[]{"download [file] from [url] %string% to %path%"});
    }
}

