/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.util.AsyncEffect;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.bukkit.event.Event;

@Name(value="Appends Text File")
@Description(value={"Appends any text to a file."})
@Examples(value={"command append:\n\ttrigger:\n\t\tcreate file \"plugins/Skript/scripts/test1.txt\" with \"My name is\"\n\t\tappend \"secret\" to file \"plugins/Skript/scripts/test1.txt\"\n\t\tbroadcast \"The text has been added!\""})
@Since(value="1.0")
public class EffAppendFile
extends AsyncEffect {
    private Expression<String> content;
    private Expression<Path> file;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.content = expr[0];
        this.file = expr[1];
        return true;
    }

    protected void execute(Event e) {
        Path path = (Path)this.file.getSingle(e);
        try {
            Files.write(path, Arrays.asList((String[])this.content.getArray(e)), Charset.forName("UTF-8"), StandardOpenOption.APPEND);
        }
        catch (IOException ex) {
            if (Files.exists(path, new LinkOption[0])) {
                Skript.exception((Throwable)ex, (String[])new String[]{"This file/directory doesn't exist: " + path});
            }
            Skript.exception((Throwable)ex, (String[])new String[0]);
        }
    }

    public String toString(Event e, boolean debug) {
        return "append " + this.content.toString(e, debug) + " to " + this.file.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAppendFile.class, (String[])new String[]{"append %strings% to %path%"});
    }
}

