/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Name(value="File is hidden?")
@Description(value={"Checks if the file is hidden or not."})
@Examples(value={"command hidden:\n\ttrigger:\n\t\tif file \"plugins/twitch.txt\" is hidden:\n\t\t\tbroadcast \"I'm sneeeaaaakyy!\""})
@Since(value="1.0")
public class CondFileIsHidden
extends PropertyCondition<Path> {
    public boolean check(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return Files.isHidden(file);
            }
            catch (IOException ex) {
                Skript.exception((Throwable)ex, (String[])new String[]{"This file/directory doesn't exist: " + file});
            }
        }
        return false;
    }

    protected String getPropertyName() {
        return "hidden";
    }

    static {
        PropertyCondition.register(CondFileIsHidden.class, (String)"hidden", (String)"path");
    }
}

