/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.objects;

import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.object.clipboard.ReadOnlyClipboard;
import com.efnilite.skematic.objects.PasteOptions;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.bukkit.Bukkit;

public class Schematic {
    private File file;
    private Clipboard clipboard;

    public Schematic(File file) {
        this.file = file;
        this.clipboard = FaweUtils.toSchematic(file).getClipboard();
    }

    public Schematic(CuboidRegion cuboid) {
        this.file = null;
        this.clipboard = new BlockArrayClipboard((Region)cuboid, (FaweClipboard)ReadOnlyClipboard.of((Extent)cuboid.getWorld(), (Region)cuboid));
    }

    public void paste(World world, BlockVector3 vector, Set<PasteOptions> options) {
        Operation operation = new ClipboardHolder(this.clipboard).createPaste((Extent)FaweUtils.getEditSession(Bukkit.getWorld((String)world.getName()))).to(vector).ignoreAirBlocks(!options.contains((Object)PasteOptions.AIR)).ignoreEntities(!options.contains((Object)PasteOptions.ENTITIES)).ignoreBiomes(!options.contains((Object)PasteOptions.BIOMES)).build();
        Operations.complete((Operation)operation);
    }

    public void save(File file, BuiltInClipboardFormat format) {
        try {
            FaweUtils.toSchematic(file).save(file, (ClipboardFormat)format);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.file.toString();
    }

    public File getFile() {
        return this.file;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }
}

