/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.objects.Schematic;
import com.efnilite.skematic.objects.SchematicLoader;
import com.sk89q.worldedit.math.BlockVector3;
import java.io.File;
import java.nio.file.Paths;
import org.bukkit.event.Event;

@Name(value="Schematic origin")
@Description(value={"Returns the origin location of a schematic (where it was copied and saved)"})
@Examples(value={"set {_origin} to the origin of \"plugins/WorldEdit/schematics/Windows.schematic\""})
@Since(value="1.0")
public class ExprSchematicOrigin
extends SimpleExpression<BlockVector3> {
    private Expression<?> schematic;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.schematic = expressions[0];
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected BlockVector3[] get(Event e) {
        Schematic schematic;
        if (this.schematic.getSingle(e) instanceof String) {
            String file = (String)this.schematic.getSingle(e);
            if (SchematicLoader.getSchematics().containsKey(file)) {
                schematic = SchematicLoader.get(file);
                return new BlockVector3[]{schematic.getClipboard().getOrigin()};
            } else {
                if (!Paths.get(file, new String[0]).toFile().exists()) {
                    Skript.error((String)("Schematic " + file + " doesn't exist!"));
                    return null;
                }
                schematic = new Schematic(new File(file));
            }
            return new BlockVector3[]{schematic.getClipboard().getOrigin()};
        }
        if (!(this.schematic.getSingle(e) instanceof Schematic)) {
            return null;
        }
        schematic = (Schematic)this.schematic.getSingle(e);
        return new BlockVector3[]{schematic.getClipboard().getOrigin()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends BlockVector3> getReturnType() {
        return BlockVector3.class;
    }

    public String toString(Event e, boolean debug) {
        return "origin of " + this.schematic.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprSchematicOrigin.class, BlockVector3.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(skematic|fawe)] [s(ch|k)em[atic]] origin (location|area) of %schematics/strings%", "%schematics/strings%'[s] [(skematic|fawe)] [s(ch|k)em[atic]] origin (location|area)"});
    }
}

