/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.bukkit.event.Event;

@Name(value="Selection points")
@Description(value={"Gets the minimal or maximal points in a cuboidregion"})
@Examples(value={"set {_point} to the maximum point of player's selection"})
@Since(value="1.5")
public class ExprCuboidRegionPoints
extends SimpleExpression<BlockVector3> {
    private int mark;
    private Expression<CuboidRegion> cuboid;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.cuboid = expressions[0];
        return true;
    }

    protected BlockVector3[] get(Event e) {
        BlockVector3 vector;
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        if (cuboid == null) {
            return null;
        }
        switch (this.mark) {
            case 1: {
                vector = cuboid.getMinimumPoint();
                break;
            }
            case 2: {
                vector = cuboid.getMinimumPoint();
                break;
            }
            default: {
                vector = null;
            }
        }
        return new BlockVector3[]{vector};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends BlockVector3> getReturnType() {
        return BlockVector3.class;
    }

    public String toString(Event e, boolean debug) {
        return "get min or max of " + this.cuboid.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprCuboidRegionPoints.class, BlockVector3.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [(skematic|fawe)] (1\u00a6min|2\u00a6max)[imum] (coord[inate]|point)[s] of %cuboidregions%", "%cuboidregions%'[s] [(skematic|fawe)] (1\u00a6min|2\u00a6max)[imum] (coord[inate]|point)[s]"});
    }
}

