/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.Event;

@Name(value="Block count")
@Description(value={"Get the block count in a cuboidregion"})
@Examples(value={"command /glass:", "\ttrigger:", "\t\tsend \"%size of glass in player's selection%\""})
@Since(value="2.0")
public class ExprCuboidRegionBlocksCount
extends SimpleExpression<Number> {
    private Expression<ItemType> block;
    private Expression<CuboidRegion> cuboid;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.block = expressions[0];
        this.cuboid = expressions[1];
        return true;
    }

    protected Number[] get(Event e) {
        ItemType item = (ItemType)this.block.getSingle(e);
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        if (cuboid == null || item == null) {
            return null;
        }
        EditSession session = FaweUtils.getEditSession(Bukkit.getServer().getWorld(cuboid.getWorld().getName()));
        List blocks = session.getBlockDistributionWithData((Region)cuboid);
        for (Countable block : blocks) {
            if (Material.getMaterial((String)((BlockState)block.getID()).getBlockType().getName().replace(" ", "_").toUpperCase()) != item.getRandom().getType()) continue;
            return new Number[]{block.getAmount()};
        }
        return new Number[]{0};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event e, boolean debug) {
        return "blocks of " + this.block.toString(e, debug) + " in " + this.cuboid.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprCuboidRegionBlocksCount.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(skematic|fawe)] (size|amount) of %itemtypes% in [region] %cuboidregions%", "%cuboidregions%'[s] [(skematic|fawe)] (size|amount) of %itemtypes%"});
    }
}

