/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Snowify")
@Description(value={"Place snow at a location - Let it go."})
@Examples(value={"snowify 1, 3, 19 in \"world\" within a radius of 10"})
@Since(value="1.0")
public class EffSnowy
extends Effect {
    private Expression<Location> location;
    private Expression<Number> radius;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.location = expressions[0];
        this.radius = expressions[1];
        return true;
    }

    protected void execute(Event e) {
        Location location = (Location)this.location.getSingle(e);
        Number radius = (Number)this.radius.getSingle(e);
        if (location == null || radius == null) {
            return;
        }
        EditSession session = FaweUtils.getEditSession(location.getWorld());
        session.simulateSnow(FaweUtils.toVector(location), ((Double)radius).doubleValue());
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "snowify " + this.location.toString(e, debug) + " with radius " + this.radius.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffSnowy.class, (String[])new String[]{"(sim[ulate]|place) snow at %location% (in|within) [a] radius [of] %number%"});
    }
}

