/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Shape - Hollow cylinder")
@Description(value={"Create a hollow cylinder at a location."})
@Examples(value={"make a new hollow cylinder at player's location with blocks grass and dirt with x radius 2 and z radius 2 and thickness 1 and height 4"})
@Since(value="2.0")
public class EffShapeHollowCylinder
extends Effect {
    private Expression<Location> location;
    private Expression<ItemType> blocks;
    private Expression<Number> x;
    private Expression<Number> z;
    private Expression<Number> thickness;
    private Expression<Number> height;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.location = expressions[0];
        this.blocks = expressions[1];
        this.x = expressions[2];
        this.z = expressions[3];
        this.thickness = expressions[4];
        this.height = expressions[5];
        return true;
    }

    protected void execute(Event e) {
        Location location = (Location)this.location.getSingle(e);
        ItemType[] blocks = (ItemType[])this.blocks.getArray(e);
        Number x = (Number)this.x.getSingle(e);
        Number z = (Number)this.z.getSingle(e);
        Number thickness = (Number)this.thickness.getSingle(e);
        Number height = (Number)this.height.getSingle(e);
        if (blocks == null || x == null || z == null || thickness == null || height == null | location == null) {
            return;
        }
        EditSession session = FaweUtils.getEditSession(location.getWorld());
        session.makeHollowCylinder(FaweUtils.toVector(location), FaweUtils.parsePattern(blocks), ((Double)x).doubleValue(), ((Double)z).doubleValue(), Math.round(((Long)height).longValue()), ((Double)thickness).doubleValue());
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "create hollow cylinder at " + this.location.toString(e, debug) + " with blocks " + this.blocks.toString(e, debug) + " with x " + this.x.toString(e, debug) + " with z " + this.z.toString(e, debug) + " with thickness " + this.thickness.toString(e, debug) + " with height " + this.height.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffShapeHollowCylinder.class, (String[])new String[]{"(make|create) [a] [new] hollow cylinder at %location% (with|and) %itemtypes% [block[s]] (with|and) x[(-| )]radius %number% (with|and) z[(-| )]radius %number% (with|and) thickness %number% (with|and) height %number%"});
    }
}

