/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.objects.Schematic;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.io.File;
import org.bukkit.event.Event;

@Name(value="Save schematic")
@Description(value={"Create a new schematic."})
@Examples(value={"save schematic selection of player to the file \"plugins/schematic.schematic\" with schematic format"})
@Since(value="2.0")
public class EffSchematicSave
extends Effect {
    private Expression<CuboidRegion> cuboid;
    private Expression<String> file;
    private Expression<BuiltInClipboardFormat> format;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.cuboid = expressions[0];
        this.file = expressions[1];
        this.format = expressions[2];
        return true;
    }

    protected void execute(Event e) {
        BuiltInClipboardFormat format;
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        String schematic = (String)this.file.getSingle(e);
        BuiltInClipboardFormat builtInClipboardFormat = format = this.format != null ? (BuiltInClipboardFormat)this.format.getSingle(e) : BuiltInClipboardFormat.SPONGE_SCHEMATIC;
        if (cuboid == null || schematic == null || format == null) {
            return;
        }
        new Schematic(cuboid).save(new File(schematic), format);
    }

    public String toString(Event e, boolean debug) {
        return "save schematic " + this.file.toString(e, debug) + " with region " + this.cuboid.toString(e, debug) + (this.format != null ? " with format " + this.format.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffSchematicSave.class, (String[])new String[]{"save [[the] s(ch|k)ematic] %cuboidregions% to [[the] file] %string% [with %-schematicformat% format]"});
    }
}

