/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@Name(value="Replace blocks")
@Description(value={"Replace all blocks with other blocks in a cuboidregion"})
@Examples(value={"replace all fawe stone and gravel with blocks air in (player's selection)"})
@Since(value="2.0")
public class EffReplaceBlocks
extends Effect {
    private Expression<ItemType> target;
    private Expression<ItemType> replacement;
    private Expression<CuboidRegion> cuboid;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.target = expressions[0];
        this.replacement = expressions[1];
        this.cuboid = expressions[2];
        return true;
    }

    protected void execute(Event e) {
        ItemType[] target = (ItemType[])this.target.getArray(e);
        ItemType[] replacement = (ItemType[])this.replacement.getArray(e);
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        if (cuboid == null || target == null || replacement == null) {
            return;
        }
        HashSet<BaseBlock> set = new HashSet<BaseBlock>();
        for (ItemType type : target) {
            set.add(new BaseBlock(type.getRandom().getType().getId(), type.getRandom().getAmount()));
        }
        EditSession session = FaweUtils.getEditSession(Bukkit.getServer().getWorld(cuboid.getWorld().getName()));
        session.replaceBlocks((Region)cuboid, set, FaweUtils.parsePattern(replacement));
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "replace all " + this.target.toString(e, debug) + " with " + this.replacement.toString(e, debug) + " in " + this.cuboid.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffReplaceBlocks.class, (String[])new String[]{"replace [all] %itemtypes% [block[s]] with %itemtypes% [block[s]] in %cuboidregions%"});
    }
}

