/*
 * Decompiled with CFR 0.152.
 */
package com.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.efnilite.skematic.utils.FaweUtils;
import com.sk89q.worldedit.EditSession;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Greenify")
@Description(value={"Greenify an area - Turns it into grass."})
@Examples(value={"greenify 2, 3, 4 in \"world\" within a radius of 20"})
@Since(value="1.0")
public class EffGreen
extends Effect {
    private Expression<Location> location;
    private Expression<Number> radius;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.location = expressions[0];
        this.radius = expressions[1];
        return true;
    }

    protected void execute(Event e) {
        Location location = (Location)this.location.getSingle(e);
        Number radius = (Number)this.radius.getSingle(e);
        if (radius == null || location == null) {
            return;
        }
        EditSession session = FaweUtils.getEditSession(location.getWorld());
        session.green(FaweUtils.toVector(location), ((Double)radius).doubleValue());
        session.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "grassify " + this.location.toString(e, debug) + " with radius " + this.radius.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffGreen.class, (String[])new String[]{"(green|grass)[ify] at %location% (in|within) [a] radius [of] %number%"});
    }
}

